#include "POF/Indata.h"
#include <math.h>
#include <algorithm>

map<double, double> MAP = { {0.5,0}, {0.9,1.28}, {0.95,1.625}, {0.975,1.96},{0.99,2.33}, {0.995,2.57} };

void init_indata(struct Indata** p_indata) {
	std::unique_ptr<Indata> new_p_indata(new Indata);
	*p_indata = new_p_indata.release();
}

void print_indata(struct Indata* indata) {
	cout<<indata->postprob[0][0][0]<<" "<<indata->postprob[0][0][1]<<" "<<indata->postprob[0][1][0]<<" "<<indata->postprob[0][1][1]<<endl;
}

double get_posterior(struct Indata* indata, int i, int j, int k) {
	return indata->postprob[i][j][k];
}


void set_normaltable(int mode, struct NN_data* nn_data, struct User_parameter* user_parameter, struct Indata* indata) {
	memset(indata->normaltable, 0, sizeof(indata->normaltable));
	memset(indata->normaltable_eff, 0, sizeof(indata->normaltable_eff));
	if (mode == 1) {
		for (int pm = 0; pm < n_label; pm++) {
			for (int j = 0; j < nn_data->n_internal_test_case; j++) {
				double max = -5000000, secmax = -5000000;
				for (int i = 0; i < nn_data->n_class; i++) {
					if (nn_data->test_case_ccon_w[pm][i][j] > max) {
						secmax = max;
						max = nn_data->test_case_ccon_w[pm][i][j];
					}
					else secmax = secmax > nn_data->test_case_ccon_w[pm][i][j] ? secmax : nn_data->test_case_ccon_w[pm][i][j];
				}
				for (int i = 0; i < nn_data->n_class; i++) {
					if (nn_data->test_case_ccon_w[pm][i][j] + user_parameter->xi > max) {
						indata->normaltable[pm][nn_data->ans[pm][j]][i][1]++;
						indata->normaltable_eff[pm][i][j][1] = 1;
					}
					if (nn_data->test_case_ccon_w[pm][i][j] - user_parameter->xi > secmax) {
						indata->normaltable[pm][nn_data->ans[pm][j]][i][0]++;
						indata->normaltable_eff[pm][i][j][0] = 1;
					}
				}
			}
		}
	}
	else if (mode == 2) {
		for (int pm = 0; pm < n_label; pm++) {
			for (int j = 0; j < nn_data->n_internal_test_case; j++) {
				double max = -5000000, secmax = -5000000;
				for (int i = 0; i < nn_data->n_class; i++) {
					if (nn_data->test_case_ccon_w[pm][i][j] > max) {
						max = nn_data->test_case_ccon_w[pm][i][j];
					}
				}
				for (int i = 0; i < nn_data->n_class; i++) {
					if (nn_data->test_case_ccon_w[pm][i][j] >= max) {
						indata->normaltable[pm][nn_data->ans[pm][j]][i][1]++;
					}
				}
			}
		}
		for (int pm = 0; pm < n_label; pm++) {
			for (int j = 0; j < user_parameter->n_rank; j++) {
				for (int i = 0; i < nn_data->n_class; i++) {
					indata->normaltable[pm][j][i][0] = indata->normaltable[pm][j][i][1] - (MAP[0.975]) * sqrt(indata->normaltable[pm][j][i][1] * (nn_data->ans_sum[pm][j] - indata->normaltable[pm][j][i][1]) / (nn_data->ans_sum[pm][j] + 0.000001));
					indata->normaltable[pm][j][i][0] = indata->normaltable[pm][j][i][0] > 0 ? indata->normaltable[pm][j][i][0] : 0;
					indata->normaltable[pm][j][i][1] = indata->normaltable[pm][j][i][1] + (MAP[0.975]) * sqrt(indata->normaltable[pm][j][i][1] * (nn_data->ans_sum[pm][j] - indata->normaltable[pm][j][i][1]) / (nn_data->ans_sum[pm][j] + 0.000001));
				}
			}
		}
	}
	else printf("ERR\n");
}

void set_posterior(struct NN_data* nn_data, struct User_parameter* user_parameter, struct Indata* indata) {
	memset(indata->postprob, 0, sizeof(indata->postprob));
	for (int i = 0; i < n_label; i++) {
		for (int j = 0; j < nn_data->n_class; j++) {
			double denominator = 0.000000000000001;
			for (int k = 0; k < user_parameter->n_rank; k++) denominator += user_parameter->context[i][k] * indata->normaltable[i][k][j][0] / (nn_data->ans_sum[i][k] + 0.000000000000001);
			for (int k = 0; k < user_parameter->n_rank; k++) {
				// cout<<"context: "<<user_parameter->context[i][k]<<endl;
				// cout<<"normaltable: "<<indata->normaltable[i][k][j][1]<<endl;
				// cout<<"ans sum: "<<nn_data->ans_sum[i][k]<<endl;
				// cout<<"denominator: "<<denominator<<endl;
				//indata->postprob[i][j][k] = (user_parameter->context[i][k] * indata->normaltable[i][k][j][1] / (nn_data->ans_sum[i][k] + 0.0000001)) / denominator;
				indata->postprob[i][j][k] = min(1.0, (user_parameter->context[i][k] * indata->normaltable[i][k][j][1] / (nn_data->ans_sum[i][k] + 0.000000000000001)) / denominator);
			}
		}
	}
}

void set_bias(int mode, struct NN_data* nn_data, struct User_parameter* user_parameter, struct Indata* indata) {
	nn_data->bias = 0;
	double increment = 0.001;
	NN_data *tmp_nn_data(new NN_data);
	*tmp_nn_data = *nn_data;



	update_indata(mode, nn_data, user_parameter, indata);
	indata->postprob[0][1][0]*=compute_effans(nn_data, user_parameter, indata);
	cout<<"Initial posterior: "<<indata->postprob[0][1][0]<<endl;

	double max_unsafe_output = -1000000;
	for (int i = 0; i < n_label; i++) {
		for (int k = 0; k < nn_data->n_internal_test_case; k++) {
			if (nn_data->ans[i][k] == 0) max_unsafe_output = max(max_unsafe_output, nn_data->test_case_ccon_w[i][0][k]);
		}
	}
	double min_safe_output = 1000000;
	for (int i = 0; i < n_label; i++) {
		for (int k = 0; k < nn_data->n_internal_test_case; k++) {
			if (nn_data->ans[i][k] == 1) min_safe_output = min(min_safe_output, nn_data->test_case_ccon_w[i][0][k]);
		}
	}

	if (indata->postprob[0][1][0] > user_parameter->th){
		while (indata->postprob[0][1][0] > user_parameter->th) {
			
			nn_data->bias += increment;
			if (-nn_data->bias < min_safe_output) {
				indata->postprob[0][1][0] = 1.0;
				break;
			}

			for (int i = 0; i < n_label; i++) {
				for (int k = 0; k < nn_data->n_internal_test_case; k++) {
					tmp_nn_data->test_case_ccon_w[i][0][k] = nn_data->test_case_ccon_w[i][0][k] + nn_data->bias; 
				}
			}

			update_indata(mode, tmp_nn_data, user_parameter, indata);
			indata->postprob[0][1][0]*=compute_effans(nn_data, user_parameter, indata);
			cout<<"posterior: "<<indata->postprob[0][1][0]<<endl;
			cout<<"bias: "<<nn_data->bias<<endl;
		}
	}
	else {
		while (indata->postprob[0][1][0] <= user_parameter->th) {
			nn_data->bias -= increment;
			if (-nn_data->bias > max_unsafe_output) {
				indata->postprob[0][1][0] = 0;
				break;
			}

			for (int i = 0; i < n_label; i++) {
				for (int k = 0; k < nn_data->n_internal_test_case; k++) {
					tmp_nn_data->test_case_ccon_w[i][0][k] = nn_data->test_case_ccon_w[i][0][k] + nn_data->bias; 
				}
			}

			update_indata(mode, tmp_nn_data, user_parameter, indata);
			indata->postprob[0][1][0]*=compute_effans(nn_data, user_parameter, indata);
			cout<<"posterior: "<<indata->postprob[0][1][0]<<endl;
			cout<<"bias: "<<nn_data->bias<<endl;
		}
		
		nn_data->bias += increment;
		for (int i = 0; i < n_label; i++) {
			for (int k = 0; k < nn_data->n_internal_test_case; k++) {
				tmp_nn_data->test_case_ccon_w[i][0][k] = nn_data->test_case_ccon_w[i][0][k] + nn_data->bias; 
			}
		}
		update_indata(mode, tmp_nn_data, user_parameter, indata);
		indata->postprob[0][1][0]*=compute_effans(nn_data, user_parameter, indata);
	}

	cout<<"Updated posterior: "<<indata->postprob[0][1][0]<<endl;
	cout<<"Bias: "<<nn_data->bias<<endl;
}

void update_indata(int mode, struct NN_data* nn_data, struct User_parameter* user_parameter, struct Indata* indata) {
	set_normaltable(mode, nn_data, user_parameter, indata);
	set_posterior(nn_data, user_parameter, indata);
}
double compute_effans(struct NN_data* nn_data, struct User_parameter* user_parameter, struct Indata* indata){
	double ratio=(user_parameter->context[0][0] * indata->normaltable[0][0][1][1] / (nn_data->ans_sum[0][0] + 0.000000000000001))/(indata->postprob[0][1][0]+1e-12);
	ratio=min(ratio,0.999);
	return 1-pow(1-ratio,16);
}